/*
 * Decompiled with CFR 0.152.
 */
package com.android.invoice.domain.use_case.discount;

import com.android.invoice.domain.model.AInvoiceDtlDto;
import com.android.invoice.domain.model.AInvoiceDto;
import com.android.invoice.domain.use_case.discount.CalcDiscount;
import com.android.invoice.domain.use_case.discount.DiscountCommissionTools;
import com.android.product.domain.model.ProductDto;
import com.customer.domain.use_case.GetCustomerList;
import com.dto.CustomerDto;
import com.dto.LoginDto;
import com.dto.MainGroupDto;
import com.dto.SideGroupDto;
import com.security.SecurityConstants;
import com.service.SettingLoader;
import com.utility.ConvertStr;
import com.utility.DateUtils;
import com.utility.DbConnection;
import com.utility.Pair;
import com.utility.TncException;
import com.utility.TncJdbc;
import java.time.LocalDateTime;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class CalcDiscount {
    private final DbConnection dbConnection;
    private final GetCustomerList getCustomerList;
    private DiscountCommissionTools discountTools;
    private AInvoiceDto dto;
    private SettingLoader settingLoader;
    private TncJdbc jdbc;
    private MainGroupDto mgDto;
    private SideGroupDto sgDto;
    private ProductDto prDto;
    private double sumFactMGroupDiscount = 0.0;
    private double sumPerRowDiscountPercent = 0.0;
    private double sumTieredPerRowDiscount = 0.0;
    private int discountState = 0;
    private CustomerDto customer;

    private void init() {
        LoginDto login = SecurityConstants.loadToken();
        this.settingLoader = new SettingLoader(this.dbConnection, login);
        this.jdbc = this.dbConnection.getJdbcTemplate(login);
        this.discountState = this.settingLoader.getDiscountMode();
        this.discountTools = new DiscountCommissionTools(this.dbConnection, this.jdbc, this.dto);
    }

    public Pair<Long, Double> invoke(AInvoiceDto dto) throws TncException {
        this.dto = dto;
        this.init();
        this.customer = this.discountTools.fetchCustomer(dto.getPartyCode(), this.getCustomerList);
        double invoiceTotalPrice = 0.0;
        double invoiceTotalAmount = 0.0;
        for (AInvoiceDtlDto dtl : dto.getDtlDto()) {
            if (dtl.getProductCode().isEmpty() || dtl.getProductCode().equals("000000")) continue;
            this.fetchProductData(dtl.getProductCode());
            dtl.setPerRowDiscountAmount(Double.valueOf(this.calcPerRowDiscount(dtl)));
            invoiceTotalPrice += dtl.getAmount() * dtl.getPrice();
            invoiceTotalAmount += dtl.getAmount();
        }
        double invoiceDiscount = this.calcDiscountSettingBased(invoiceTotalPrice, invoiceTotalAmount);
        return Pair.of((Object)Math.round(invoiceDiscount), (Object)this.sumPerRowDiscountPercent);
    }

    private void fetchProductData(String productCode) {
        this.mgDto = this.discountTools.getMainGroup(productCode.substring(0, 2), this.jdbc);
        this.sgDto = this.discountTools.getSubGroup(productCode, this.jdbc);
        this.prDto = this.discountTools.getProduct(productCode, this.jdbc);
    }

    private double calcPerRowDiscount(AInvoiceDtlDto dtl) {
        double result = 0.0;
        double tieredRowDiscount = 0.0;
        int tieredDiscountMode = this.settingLoader.getTieredDiscountMode();
        if (this.settingLoader.mGroupCustomerDiscountEnabled() && this.mgDto.isSelected()) {
            this.sumFactMGroupDiscount += (double)Math.round(dtl.getAmount() * dtl.getPrice());
        }
        if (this.discountState != 2) {
            this.sumPerRowDiscountPercent = 0.0;
            if (this.tieredDiscountEnabled()) {
                tieredRowDiscount = this.makeDataAndCalcTieredDiscountCommission(1, dtl, 0.0);
                this.sumTieredPerRowDiscount += tieredRowDiscount;
            }
        } else if (!this.settingLoader.useRialDiscountPercent() && !this.settingLoader.isUsePerRowDiscountPrice()) {
            if (this.settingLoader.useDueDateForDiscountEnabled()) {
                result = this.calcOnDiscountDueDateEnabled(dtl, result);
            } else if (this.settingLoader.isProductDiscountPerMGroup()) {
                result = dtl.getAmount() * dtl.getPrice() * this.mgDto.getDiscountpercent() / 100.0;
            } else if (this.settingLoader.isProductDiscountPerSGroup()) {
                result = dtl.getAmount() * dtl.getPrice() * this.sgDto.getDiscountpercent() / 100.0;
            } else if (this.settingLoader.productDiscountPercentEnabled()) {
                result = dtl.getAmount() * dtl.getPrice() * this.prDto.getDiscountPercent() / 100.0;
            }
            this.sumPerRowDiscountPercent += result;
            if (this.tieredDiscountEnabled()) {
                tieredRowDiscount = tieredDiscountMode == 0 ? this.makeDataAndCalcTieredDiscountCommission(1, dtl, 0.0) : this.makeDataAndCalcTieredDiscountCommission(1, dtl, dtl.getAmount() * dtl.getPrice() * this.prDto.getDiscountPercent() / 100.0);
            }
            this.sumTieredPerRowDiscount += tieredRowDiscount;
        } else {
            result = this.settingLoader.useDueDateForDiscountEnabled() ? this.calcOnDiscountDueDateEnabled(dtl, result) : (this.settingLoader.isProductDiscountPerMGroup() ? dtl.getAmount() * this.mgDto.getDiscountprice() : (this.settingLoader.isProductDiscountPerSGroup() ? dtl.getAmount() * this.sgDto.getDiscountprice() : (this.settingLoader.isUsePerRowDiscountPrice() ? dtl.getAmount() * this.prDto.getDiscountPrice() : this.prDto.getDiscountPrice())));
            this.sumPerRowDiscountPercent += result;
            if (this.tieredDiscountEnabled()) {
                tieredRowDiscount = tieredDiscountMode == 0 ? this.makeDataAndCalcTieredDiscountCommission(1, dtl, 0.0) : this.makeDataAndCalcTieredDiscountCommission(1, dtl, this.prDto.getDiscountPrice());
                this.sumTieredPerRowDiscount += tieredRowDiscount;
            }
        }
        return result + tieredRowDiscount;
    }

    private double calcOnDiscountDueDateEnabled(AInvoiceDtlDto dtl, double result) {
        if (this.settingLoader.isProductDiscountPerMGroup()) {
            result = dtl.getAmount() * dtl.getPrice() * this.getGroupOrProductDiscountBasedOnSettings(1) / 100.0;
        } else if (this.settingLoader.isProductDiscountPerSGroup()) {
            result = dtl.getAmount() * dtl.getPrice() * this.getGroupOrProductDiscountBasedOnSettings(2) / 100.0;
        } else if (this.settingLoader.productDiscountPercentEnabled()) {
            result = dtl.getAmount() * dtl.getPrice() * this.getGroupOrProductDiscountBasedOnSettings(3) / 100.0;
        }
        return result;
    }

    private double getGroupOrProductDiscountBasedOnSettings(int kind) {
        LocalDateTime invoiceDate = DateUtils.parseLocalDateTime((String)this.dto.getInvoiceDate());
        switch (kind) {
            case 1: {
                if (this.isInvoiceDateOutsideDueDates(invoiceDate, this.mgDto.getFromDueDate(), this.mgDto.getToDueDate())) {
                    return 0.0;
                }
                if (this.settingLoader.isUsePerRowDiscountPrice()) {
                    return this.mgDto.getDiscountprice();
                }
                return this.mgDto.getDiscountpercent();
            }
            case 2: {
                if (this.isInvoiceDateOutsideDueDates(invoiceDate, this.sgDto.getFromDueDate(), this.sgDto.getToDueDate())) {
                    return 0.0;
                }
                if (this.settingLoader.isUsePerRowDiscountPrice()) {
                    return this.sgDto.getDiscountprice();
                }
                return this.sgDto.getDiscountpercent();
            }
            case 3: {
                if (this.isInvoiceDateOutsideDueDates(invoiceDate, this.prDto.getFromDueDate(), this.prDto.getToDueDate())) {
                    return 0.0;
                }
                if (this.settingLoader.isUsePerRowDiscountPrice()) {
                    return this.prDto.getDiscountPrice();
                }
                return this.prDto.getDiscountPercent();
            }
        }
        return 0.0;
    }

    private boolean isInvoiceDateOutsideDueDates(LocalDateTime invoiceDate, LocalDateTime fromDueDate, LocalDateTime toDueDate) {
        return invoiceDate.isBefore(fromDueDate) || invoiceDate.isAfter(toDueDate);
    }

    private double makeDataAndCalcTieredDiscountCommission(int actionType, AInvoiceDtlDto dtl, double invoiceDiscount) {
        if (!ConvertStr.partOf((Object)this.discountState, (Object[])new Integer[]{1, 2}) || !this.settingLoader.tieredDiscountEnabled()) {
            return 0.0;
        }
        TieredDiscountOrCommissionData tieredDiscountData = new TieredDiscountOrCommissionData(RequestType.DISCOUNT, invoiceDiscount, actionType, dtl.getProductCode(), dtl.getAmount(), dtl.getPrice(), dtl.getThirdAmount().doubleValue(), dtl.getSecondAmount().doubleValue(), dtl.getUnitCode(), dtl.getCoefficient().doubleValue(), 0.0);
        return this.discountTools.calcTieredDiscountCommission(tieredDiscountData);
    }

    private double calcDiscountSettingBased(double invoiceTotalPrice, double invoiceTotalAmount) {
        double result;
        double localSumTieredDiscount = 0.0;
        if (this.tieredDiscountEnabled()) {
            AInvoiceDtlDto dtl = AInvoiceDtlDto.builder().productCode("").amount(invoiceTotalAmount).price(invoiceTotalPrice).thirdAmount(Double.valueOf(0.0)).secondAmount(Double.valueOf(0.0)).coefficient(Double.valueOf(0.0)).unitCode("0").build();
            double totalInvoiceTieredDiscount = this.settingLoader.getTieredDiscountMode() == 0 ? this.makeDataAndCalcTieredDiscountCommission(0, dtl, this.sumTieredPerRowDiscount) : this.makeDataAndCalcTieredDiscountCommission(0, dtl, this.sumPerRowDiscountPercent + this.sumTieredPerRowDiscount);
            localSumTieredDiscount = totalInvoiceTieredDiscount + this.sumTieredPerRowDiscount;
            if (localSumTieredDiscount > invoiceTotalPrice) {
                localSumTieredDiscount = invoiceTotalPrice;
            }
        }
        if (this.settingLoader.customerDiscountIneffectiveOnServicesEnabled()) {
            boolean usedDiscountPercent = this.discountState == 2;
            result = !usedDiscountPercent ? this.sumPerRowDiscountPercent + this.customer.getCommission() * (invoiceTotalPrice - this.sumPerRowDiscountPercent) / 100.0 : this.customer.getCommission() * (invoiceTotalPrice - this.sumPerRowDiscountPercent) / 100.0;
            if (result < 0.0) {
                result = 0.0;
            }
        } else {
            result = this.settingLoader.tieredDiscountEnabled() ? (this.settingLoader.getTieredDiscountMode() == 0 ? this.customer.getCommission() * (invoiceTotalPrice - localSumTieredDiscount) / 100.0 : this.customer.getCommission() * (invoiceTotalPrice - this.sumPerRowDiscountPercent - localSumTieredDiscount) / 100.0) : this.customer.getCommission() * (invoiceTotalPrice - this.sumPerRowDiscountPercent - localSumTieredDiscount) / 100.0;
        }
        if (this.settingLoader.mGroupCustomerDiscountEnabled()) {
            result = this.customer.getCommission() * (this.sumFactMGroupDiscount - this.sumPerRowDiscountPercent - localSumTieredDiscount) / 100.0;
        }
        if (this.tieredDiscountEnabled()) {
            result += localSumTieredDiscount;
        }
        return result += this.sumPerRowDiscountPercent;
    }

    private boolean tieredDiscountEnabled() {
        return this.settingLoader.tieredDiscountEnabled() && ConvertStr.partOf((Object)this.discountState, (Object[])new Integer[]{1, 2});
    }

    public CalcDiscount(DbConnection dbConnection, GetCustomerList getCustomerList) {
        this.dbConnection = dbConnection;
        this.getCustomerList = getCustomerList;
    }
}

